<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;


class CircleSubCategory extends BaseAdminController
{
    
    public function list($circle_id)
    {
        $list = \app\common\model\CircleSubCategory::where('circle_id',$circle_id)
        ->select()->toArray();
        $list = linear_to_tree($list);
        return show(config('status.success'),'list',$list);
    }

    public function detail($id)
    {
        $data = \app\common\model\CircleSubCategory::find($id);

        return show(config('status.success'),'',$data);
    }

    public function del($id)
    {
        \app\common\model\CircleSubCategory::where('id',$id)->delete();

        return show(config('status.success'),'删除成功');
    }

    public function update()
    {
        $params = $this->request->post();
        \app\common\model\CircleSubCategory::update($params);
        
        return show(config('status.success'),'修改成功');
    }

    public function add()
    {
        $params = $this->request->post();
        
        \app\common\model\CircleSubCategory::create($params);

        return show(config('status.success'),'添加成功');
        
    }

}