<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;



/**
 * 聊天内容收藏
 * Class CollectController
 * @package app\api\controller
 */
class ChatCollect extends BaseAdminController
{

    /**
     * 列表
     */
    public function list()
    {
        $list = \app\common\model\ChatCollect::with(['fromUser'])
        ->order('create_time','desc')
        ->select()
        ->toArray();

        return show(config('status.success'),'我的收藏',$list);
    }

    /**
     * 修改状态
     */
    public function status()
    {
       $params = $this->request->post();

       \app\common\model\ChatCollect::where('id',$params['id'])->update($params);

       return show(config('status.success'),'修改成功');
    }

    /**
     * 删除
     */
    public function del($id)
    {
        \app\common\model\ChatCollect::where('id',$id)->delete();
        
        return show(config('status.success'),'删除成功');
    }

}