<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\validate\settings\order;

use app\common\validate\BaseValidate;

/**
 * 交易设置验证器
 * Class TransactionSettingsValidate
 * @package app\adminapi\validate\settings\order
 */
class TransactionSettingsValidate extends BaseValidate
{
    protected $rule = [
        'cancel_unpaid_orders' => 'require|in:0,1',
        'cancel_unpaid_orders_times' => 'requireIf:cancel_unpaid_orders,1|integer|gt:0',
        'cancel_unshipped_orders' => 'require|in:0,1',
        'cancel_unshipped_orders_times' => 'requireIf:cancel_unshipped_orders,1|integer|gt:0',
        'automatically_confirm_receipt' => 'require|in:0,1',
        'automatically_confirm_receipt_days' => 'requireIf:automatically_confirm_receipt,1|integer|gt:0',
        'after_sales' => 'require|in:0,1',
        'after_sales_days' => 'requireIf:after_sales,1|integer|gt:0',
        'inventory_occupancy' => 'require|in:1',
        'return_inventory' => 'require|in:0,1'

    ];

    protected $message = [
        'cancel_unpaid_orders.require' => '请选择系统取消待付款订单方式',
        'cancel_unpaid_orders.in' => '系统取消待付款订单状态值有误',
        'cancel_unpaid_orders_times.requireIf' => '系统取消待付款订单时间未填写',
        'cancel_unpaid_orders_times.integer' => '系统取消待付款订单时间须为整型',
        'cancel_unpaid_orders_times.gt' => '系统取消待付款订单时间须大于0',

        'cancel_unshipped_orders.require' => '请选择买家取消待发货订单方式',
        'cancel_unshipped_orders.in' => '买家取消待发货订单状态值有误',
        'cancel_unshipped_orders_times.requireIf' => '买家取消待发货订单时间未填写',
        'cancel_unshipped_orders_times.integer' => '买家取消待发货订单时间须为整型',
        'cancel_unshipped_orders_times.gt' => '买家取消待发货订单时间须大于0',

        'automatically_confirm_receipt.require' => '请选择系统确认收货方式',
        'automatically_confirm_receipt.in' => '系统确认收货状态值有误',
        'automatically_confirm_receipt_days.requireIf' => '系统确认收货时间未填写',
        'automatically_confirm_receipt_days.integer' => '系统确认收货时间须为整型',
        'automatically_confirm_receipt_days.gt' => '系统确认收货时间须大于0',

        'after_sales.require' => '请选择买家售后维权时效方式',
        'after_sales.in' => '买家售后维权时效状态值有误',
        'after_sales_days.requireIf' => '买家售后维权时间未填写',
        'after_sales_days.integer' => '买家售后维权时间须为整型',
        'after_sales_days.gt' => '买家售后维权时间须大于0',

        'inventory_occupancy.require' => '请选择库存占用时机',
        'inventory_occupancy.in' => '库存占用时机状态值有误',

        'return_inventory.require' => '请选择取消订单退回库存方式',
        'return_inventory.in' => '取消订单退回库存状态值有误',


    ];
}