<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate\auth;
use app\adminapi\logic\auth\AuthLogic;
use app\common\{
    model\Role,
    model\Admin,
    validate\BaseValidate
};

/**
 * 角色验证器
 * Class RoleValidate
 * @package app\adminapi\validate\auth
 */
class RoleValidate extends BaseValidate
{
    protected $rule = [
        'id'        => 'require|checkRole',
        'name'      => 'require|max:64|unique:'.Role::class.',name',
        'auth_keys' => 'array|checkAuth',
    ];

    protected $message = [
        'id.require'        => '请选择角色',
        'name.require'      => '请输入角色名称',
        'name.max'          => '角色名称最长为16个字符',
        'name.unique'       => '角色名称已存在',
        'auth_keys.array'   => '权限格式错误'
    ];

    public function sceneAdd()
    {
        return $this->only(['name', 'auth_keys']);
    }

    public function sceneDetail()
    {
        return $this->only(['id']);
    }

    public function sceneDel()
    {
        return $this->only(['id'])
            ->append('id', 'checkAdmin');
    }

    //验证角色是否存在
    public function checkRole($value,$rule,$data)
    {
        if (!Role::find($value)) {
            return '角色不存在';
        }
        return true;
    }

    //验证角色是否被使用
    public function checkAdmin($value,$rule,$data)
    {
        if (Admin::where(['role_id'=>$value])->find()) {
            return '有管理员在使用该角色，不允许删除';
        }

        return true;
    }

    //验证权限数据是否完整
    public function checkAuth($value,$rule,$data)
    {
        $configAuth = AuthLogic::getAuth();

        foreach ($value as $postAuth){
            $keyList = explode('/',$postAuth);
            if(empty($keyList)){

                return '权限数据错误';
            }
            $keys = explode('.',$keyList[1] ?? '');
            if(count($keys) < 2){
                return '权限数据错误';
            }
            $auth = $configAuth[$keyList[0]][$keys[0]][$keys[1]] ?? [];
            if(empty($auth)){
                return '权限数据错误';
            }
        }
        return true;

    }
}