<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate\ad;

use app\common\enum\FreeShippingEnum;

use app\common\validate\BaseValidate;

/**
 * 广告位
 */
class AdValidate extends BaseValidate
{
    protected $rule = [
        'id'        => 'require',
        'name'      => 'require|max:60',
        'pid'       => 'require',
        'image'     => 'require',
        'link_type' => 'checkLink',
    ];

    protected $message = [
        'id.require'        => 'id不可为空',
        'name.require'      => '请输入广告标题',
        'name.max'          => '广告标题过长',
        'pid.require'       => '请选择广告位置',
        'image.require'     => '请上传广告图片',

    ];
    protected function sceneAdd()
    {
        $this->remove(['id']);
    }



    public function sceneDel()
    {
        $this->only(['id']);
    }


    public function checkLink($value,$rule,$data){

        return true;
    }
}
