<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic;

use app\common\enum\DefaultEnum;
use app\common\enum\YesNoEnum;
use app\common\logic\BaseLogic;
use app\common\model\Circle;
use app\common\service\FileService;

class CircleLogic extends BaseLogic
{


    /**
     * @notes 查看详情
     * @param $params
     * @return array
     */
    public static function detail($params)
    {
        $data =Circle::with(['user'])->findOrEmpty($params['id'])->toArray();
        return  $data;
    }

    /**
     * @notes 添加
     * @param $params
     */
    public static function add($params)
    {
        $image = isset($params['icon']) && !empty($params['icon']) ? FileService::setFileUrl($params['icon']) : '';
        $data = [
            'name' => $params['name'],
            'synopsis' => $params['synopsis'],
            'user_id' => $params['user_id']??0,
            'edit_template'=>$params['edit_template'],
            'cate_id' => $params['cate_id'],
            'subscription_price' => $params['subscription_price'],
            'release_price' => $params['release_price'],
            'icon' => $image,
            'send_limit_day' => $params['send_limit_day'],
            'sort' => $params['sort'] ?? DefaultEnum::SORT,
            'is_show' => $params['is_show'] ?? YesNoEnum::YES,
            'home_show' => $params['home_show'] ?? YesNoEnum::YES,
            'create_time' => time(),
            'visit_level' => $params['visit_level'],
            'send_level' => $params['send_level'],
            'reply_level' => $params['reply_level'],
            'disable_reply' => $params['disable_reply'],
            'disbale_upload_image' => $params['disbale_upload_image'],
            'diable_upload_file' => $params['diable_upload_file'],
            'label' => $params['label'],
            'only_circle_send'=>$params['only_circle_send'],
            'signal_get_experience'=>$params['signal_get_experience']??0,
            'bg_image' => $params['bg_image'] ?? '',
        ];

        return Circle::create($data);
    }


    /**
     * @notes 编辑
     * @param $params
     */
    public static function edit($params)
    {
        $image = isset($params['icon']) && !empty($params['icon']) ? FileService::setFileUrl($params['icon']) : '';
        
        $data = [
            'name' => $params['name'],
            'cate_id' => $params['cate_id'],
            'user_id' => $params['user_id'],
            'vip_level_id' => $params['vip_level_id'],
            'chat_status' => $params['chat_status'],
            'bg_image' => $params['bg_image'],
            'template' => $params['template'],
            'subscription_price' => $params['subscription_price'],
            'release_price' => $params['release_price'],
            'synopsis' => $params['synopsis'],
            'send_limit_day' => $params['send_limit_day'],
            'icon' => $image,
            'sort' => $params['sort'] ?? DefaultEnum::SORT,
            'is_show' => $params['is_show'] ?? YesNoEnum::YES,
            'home_show' => $params['home_show'] ?? YesNoEnum::YES,
            'create_time' => time(),
            'visit_level' => $params['visit_level'],
            'send_level' => $params['send_level'],
            'reply_level' => $params['reply_level'],
            'disable_reply' => $params['disable_reply'],
            'disbale_upload_image' => $params['disbale_upload_image'],
            'diable_upload_file' => $params['diable_upload_file'],
            'notice' => $params['notice'],
            'label' => $params['label'],
            'only_circle_send'=>$params['only_circle_send'],
            'edit_template'=>$params['edit_template'],
            'signal_get_experience'=>$params['signal_get_experience'],

            'info_mobile_check_status'=>$params['info_mobile_check_status'],
            'info_mobile_require'=>$params['info_mobile_require'],
            'info_wechat_require'=>$params['info_wechat_require'],
            'info_contact_require'=>$params['info_contact_require'],

            
            'show_title'=>$params['show_title'],
        ];

        return Circle::update($data,['id' => $params['id']]);
    }

    /**
     * @notes 删除
     * @param $params
     */
    public static function delete($params)
    {
        Circle::destroy($params['id']);

        // 删除圈子下是字段
        if(\isActivePluginByPluginName('field')){
            \app\common\model\CircleField::where('circle_id',$params['id'])->delete();
        }
    }

    /**
     * @notes 修改是否显示状态
     * @param $params
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function show($params)
    {
        $article = Circle::find($params['id']);
        $data = [];
        if(isset($params['is_show'])){
            $data['is_show'] = $params['is_show'];
        }
        if(isset($params['home_show'])){
            $data['home_show'] = $params['home_show'];
        }
        if(isset($params['chat_status'])){
            $data['chat_status'] = $params['chat_status'];
        }
        if(isset($params['is_hot'])){
            $data['is_hot'] = $params['is_hot'];
        }
        if(isset($params['is_recommend'])){
            $data['is_recommend'] = $params['is_recommend'];
        }
        
        $article->save($data);
    }

    /**
     * @notes 审核状态
     * @param $params
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function status($params)
    {
        $article = Circle::find($params['id']);
        $article->save([ 'status'=> $params['status']]);
    }


}