<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\lists\user;

use app\adminapi\lists\BaseAdminDataLists;
use app\common\model\User;
use app\common\model\VipLevel;

/**
 * 会员等级列表
 * Class VipLevelLists
 * @package app\adminapi\lists\user
 */
class VipLevelLists extends BaseAdminDataLists
{

    /**
     * @notes 会员等级列表
     * @return array
     */
    public function lists(): array
    {
        $lists = VipLevel::field('id,name,rank,image,discount,function,color')
            ->limit($this->limitOffset, $this->limitLength)
            ->order('rank', 'asc')
            ->select();

        $leveCount = User::group('level')->column('count(id) as num', 'level');

        foreach ($lists as  $level) {
            if($level->discount > 0){
                $level->discount = floatval($level->discount).'折';
            }else{
                $level->discount = '无';
            }
            $level->num = $leveCount[$level['id']] ?? 0;
        }

        return $lists->toArray();
    }

    /**
     * @notes 会员等级总数
     * @return int
     */
    public function count(): int
    {
        return VipLevel::count();
    }
}