<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\lists\user;
use app\adminapi\lists\BaseAdminDataLists;
use app\common\{
    model\User,
    enum\UserTerminalEnum,
    lists\ListsExtendInterface
};

/**
 * 粉丝列表
 * Class UserFansLists
 * @package app\adminapi\lists\user
 */
class UserFansLists extends BaseAdminDataLists implements ListsExtendInterface
{

    /**
     * @notes 搜索参数
     * @return array
     */

    public function setSearch(): array
    {
        $user_id = $this->params['user_id'];
        $level = $this->params['level'] ?? 1;
        $where=  [];
        if(isset($this->params['keyword'])){
            $where[] = ['sn|nickname','like','%'.$this->params['keyword'].'%'];
        }
        switch ($level){
            case 1:
                $where[] = ['first_leader','=',$user_id];
                break;
            case 2:
                $where[] = ['second_leader','=',$user_id];
                break;
        }
        return $where;

    }

    public function extend(): array
    {
        $user_id = $this->params['user_id'];
        $statistics['first_count'] = User::where(['first_leader'=>$user_id])->count();
        $statistics['second_count'] = User::where(['second_leader'=>$user_id])->count();

        return $statistics;
    }

    /**
     * @notes 用户粉丝列表
     * @return array
     */
    public function lists(): array
    {
        $list = User::with('user_level')
            ->where($this->setSearch())
            ->field('id,sn,nickname,level,first_leader,avatar,mobile,create_time,register_source')
            ->select()->toArray();

        $userIds = array_column($list,'first_leader');
        $userList = User::where(['id'=>$userIds])->column('nickname,avatar','id');
        foreach ($list as $key => $user){
            $list[$key]['leader_name'] = $userList[$user['first_leader']]['nickname'] ?? '';
            $list[$key]['leader_avatar'] = $userList[$user['first_leader']]['avatar'] ?? '';
            $list[$key]['register_source'] = UserTerminalEnum::getTermInalDesc($user['register_source']);
        }
        return $list;
    }

    /**
     * @notes 会员等级总数
     * @return int
     */
    public function count(): int
    {
        return  User::where($this->setSearch())->count();
    }
}