<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\lists\user;

use app\adminapi\lists\BaseAdminDataLists;
use app\common\lists\ListsSearchInterface;
use app\common\model\User;

/**
 * 选择用户列表
 * Class SelectUserLists
 * @package app\adminapi\lists\user
 */
class SelectUserLists extends BaseAdminDataLists implements ListsSearchInterface
{
    /**
     * @notes 设置搜索
     * @return \string[][]
     */
    public function setSearch(): array
    {
        return [
            '=' => ['d.is_distribution'],
            '%like%' => ['u.sn', 'u.nickname']
        ];
    }

    /**
     * @notes 搜索
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $field = [
            'u.id',
            'u.sn',
            'u.nickname',
            'u.mobile',
            'u.avatar',
            'u.create_time',
            'u.user_money',
            'd.is_distribution'
        ];

        $lists = User::alias('u')
            ->leftJoin('distribution d', 'd.user_id = u.id')
            ->field($field)
            ->where($this->searchWhere)
            ->limit($this->limitOffset, $this->limitLength)
            ->select()
            ->toArray();

        return $lists;
    }

    /**
     * @notes 记录数
     * @return int
     */
    public function count(): int
    {
        $count = User::alias('u')
            ->leftJoin('distribution d', 'd.user_id = u.id')
            ->where($this->searchWhere)
            ->count();

        return $count;
    }
}