<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\lists\sign;

use app\adminapi\lists\BaseAdminDataLists;
use app\common\lists\ListsExcelInterface;
use app\common\lists\ListsSearchInterface;
use app\common\model\SignLog;
use app\common\service\FileService;

/**
 * 签到记录列表
 * Class SignLists
 * @package app\adminapi\lists\sign
 */
class SignLists extends BaseAdminDataLists implements ListsSearchInterface,ListsExcelInterface
{
    /**
     * @notes 导出字段
     * @return array
     */
    public function setExcelFields(): array
    {
       return [
           'nickname' => '用户昵称',
           'money' => '每日签到奖励',
           'continuous_money' => '连续签到奖励',
           'days' => '连续签到天数',
           'create_time' => '签到时间',
       ];
    }

    /**
     * @notes 导出表名
     * @return string
     */
    public function setFileName(): string
    {
        return '签到记录表';
    }

    /**
     * @notes 设置搜索
     * @return array
     */
    public function setSearch(): array
    {
        return [
            '=' => ['u.sn', 'u.mobile'],
            '%like%' => ['u.nickname'],
            'between_time' => 'sl.create_time'
        ];
    }

    /**
     * @notes 签到记录列表
     * @return array
     */
    public function lists(): array
    {
        $field = 'sl.id,sl.money,sl.continuous_money,sl.days,sl.create_time';
        $field .= ',u.avatar,u.nickname';
        $lists = SignLog::alias('sl')
            ->leftJoin('user u', 'u.id = sl.user_id')
            ->field($field)
            ->where($this->searchWhere)
            ->order('sl.id','desc')
            ->limit($this->limitOffset, $this->limitLength)
            ->select()
            ->toArray();
        foreach($lists as &$item) {
            $item['avatar'] = FileService::getFileUrl($item['avatar']);
        }
        return $lists;
    }

    /**
     * @notes 签到记录数量
     * @return int
     */
    public function count(): int
    {
        $count = SignLog::alias('sl')
            ->leftJoin('user u', 'u.id = sl.user_id')
            ->where($this->searchWhere)
            ->count();

        return $count;
    }
}