<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\lists\notice;

use app\adminapi\lists\BaseAdminDataLists;
use app\common\enum\NoticeEnum;
use app\common\enum\YesNoEnum;
use app\common\lists\ListsSearchInterface;
use app\common\model\NoticeSetting;

/**
 * 通知设置
 * Class NoticeSettingLists
 * @package app\adminapi\lists\notice
 */
class NoticeSettingLists extends BaseAdminDataLists implements ListsSearchInterface
{
    public function setSearch(): array
    {
        return [
            '=' => ['recipient', 'type']
        ];
    }

    /**
     * @notes 通知设置列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $lists = NoticeSetting::field('*,type as type_desc,recipient as recipient_desc')
            ->where($this->searchWhere)
            ->order([
                'recipient' => 'asc',
                'type' => 'asc',
            ])
            ->select()
            ->toArray();

        foreach($lists as &$item) {
            if(empty($item['system_notice'])) {
                $item['system_notice']['status'] = YesNoEnum::NO;
                $item['sms_notice']['status'] = YesNoEnum::NO;
                $item['oa_notice']['status'] = YesNoEnum::NO;
                $item['mnp_notice']['status'] = YesNoEnum::NO;
            }
        }

        return $lists;
    }

    /**
     * @notes 通知设置数量
     * @return int
     */
    public function count(): int
    {
        $count = NoticeSetting::where($this->searchWhere)->count();

        return $count;
    }
}