<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\lists\goods;
use app\adminapi\lists\BaseAdminDataLists;
use app\common\{model\Goods, model\GoodsCategory, model\GoodsCategoryIndex, lists\ListsSearchInterface};

/**
 * 商品分类公共列表
 * Class GoodsCommonLists
 * @package app\adminapi\lists\goods
 */
class GoodsCategoryCommonLists  extends BaseAdminDataLists implements ListsSearchInterface
{
    function setSearch(): array
    {
        return [
            '%like%'    => ['name'],
            '='         => ['level'],
        ];
    }


    public function lists(): array
    {

        $lists = GoodsCategory::where($this->searchWhere)
            ->limit($this->limitOffset, $this->limitLength)
            ->order('id', 'asc')
            ->column('id,name,image,level,0 as num','id');

        $categoryIds = array_keys($lists);

        if($categoryIds){

            $categoryCountLists = Goods::alias('G')
                ->join('goods_category_index GCI','G.id = GCI.goods_id')
                ->where(['GCI.category_id'=>$categoryIds])
                ->group('GCI.category_id')
                ->column('count(goods_id) as num,GCI.category_id');

            foreach ($categoryCountLists as $countList){
                if(isset($lists[$countList['category_id']])){
                    $lists[$countList['category_id']]['num'] = $countList['num'];
                }
            }

        }
        return array_values($lists);
    }

    public function count(): int
    {
        $count = GoodsCategory::where($this->searchWhere)
            ->count();
        return $count;
    }

}