<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\lists\auth;

use app\adminapi\lists\BaseAdminDataLists;
use app\common\lists\ListsExcelInterface;
use app\common\lists\ListsExtendInterface;
use app\common\lists\ListsSearchInterface;
use app\common\lists\ListsSortInterface;
use app\common\model\Admin;
use app\common\model\Role;

class AdminLists extends BaseAdminDataLists implements ListsExtendInterface, ListsSearchInterface, ListsSortInterface, ListsExcelInterface
{
    /**
     * @notes 设置导出字段
     * @return string[]
     */
    public function setExcelFields(): array
    {
        return [
            'account' => '账号',
            'name' => '名称',
            'role_name' => '角色',
            'create_time' => '创建时间',
            'login_time' => '最后登录时间',
            'login_ip' => '最后登录IP',
            'disable_desc' => '状态',
        ];
    }

    /**
     * @notes 设置导出文件名
     * @return string
     */
    public function setFileName(): string
    {
        return '管理员列表';
    }

    /**
     * @notes 设置搜索条件
     * @return \string[][]
     */
    public function setSearch(): array
    {
        return [
            '%like%' => ['name', 'account'],
            '=' => ['role_id']
        ];
    }

    /**
     * @notes 设置支持排序字段
     * @return string[]
     */
    public function setSortFields(): array
    {
        // 格式: ['前端传过来的字段名' => '数据库中的字段名'];
        return ['create_time' => 'create_time', 'id' => 'id'];
    }

    /**
     * @notes 设置默认排序
     * @return string[]
     */
    public function setDefaultOrder(): array
    {
        return ['id' => 'desc'];
    }


    /**
     * @notes 获取管理列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $adminLists = Admin::field(['id', 'name','root', 'account', 'role_id', 'create_time', 'disable', 'login_time', 'login_ip', 'multipoint_login', 'avatar'])
            ->where($this->searchWhere)
            ->append(['disable_desc'])
            ->limit($this->limitOffset, $this->limitLength)
            ->order($this->sortOrder)
            ->select()
            ->toArray();

        //获取角色数组（'角色id'=>'角色名称')
        $roleLists = Role::column('name', 'id');

        //管理员列表增加角色名称
        foreach ($adminLists as $k => $v) {
            $adminLists[$k]['role_name'] = $roleLists[$v['role_id']] ?? '';
            if($v['root']){
                $adminLists[$k]['role_name'] = '超级管理员';
            }
        }

        return $adminLists;
    }

    /**
     * @notes 获取数量
     * @return int
     */
    public function count(): int
    {
        return Admin::where($this->searchWhere)->count();
    }

    public function extend()
    {
        return [];
    }
}