<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\lists;


use app\common\lists\ListsSearchInterface;
use app\common\model\File;
use app\common\model\FileCate;
use app\common\service\UrlService;

class FileCateLists extends BaseAdminDataLists implements ListsSearchInterface
{
    /**
     * @notes 文件分类搜素条件
     * @return array
     */
    public function setSearch(): array
    {
        return [
            '=' => ['type']
        ];
    }

    /**
     * @notes 获取文件分类列表
     * @return array
     * @throws @\think\db\exception\DataNotFoundException
     * @throws @\think\db\exception\DbException
     * @throws @\think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $lists = (new FileCate())->field(['id,pid,type,name'])
            ->where($this->searchWhere)
            ->select()->toArray();

        return linear_to_tree($lists, 'children');
    }

    /**
     * @notes 获取文件分类数量
     * @return int
     */
    public function count(): int
    {
        return (new FileCate())->where($this->searchWhere)->count();
    }
}