<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\lists;

use app\common\lists\ListsSearchInterface;
use app\common\model\Article;
use app\common\model\ArticleCategory;
use app\common\model\ArticleComment;

class ArticleCommentLists extends BaseAdminDataLists implements ListsSearchInterface
{


    /**
     * @notes 设置搜索
     * @return \string[][]
     */
    public function setSearch(): array
    {
        return [
            '=' => [ 'aid']
        ];
    }

    /**
     * @notes 自定义搜索
     */
    public function queryWhere()
    {
       
    }


    /**
     * @notes 文章/帮助列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $this->queryWhere();
        $lists = ArticleComment::alias('ac')
            ->join('user u','ac.user_id = u.id')
            ->field('ac.*,nickname,sn')
            ->where($this->searchWhere)
            ->limit($this->limitOffset, $this->limitLength)
            ->select()
            ->toArray();

        return $lists;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        $this->queryWhere();
        return ArticleComment::alias('ac')->join('user u','ac.user_id = u.id')->where($this->searchWhere)->count();
    }
}