<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller;


use app\common\service\UploadService;
use app\common\validate\UploadValidate;
use Exception;
use think\response\Json;

class Upload extends BaseAdminController
{
    /**
     * @notes 上传图片
     * @return Json
     */
    public function image()
    {
        (new UploadValidate())->goCheck(null,['file'=>$this->request->file()]);
        try {
            $cid = $this->request->post('cid', 0);
            $result = UploadService::image($cid,$this->adminId);
            return $this->success('上传成功', $result);
        } catch (Exception $e) {
            return $this->fail($e->getMessage());
        }
    }

    /**
     * @notes 上传视频
     * @return Json
     */
    public function video()
    {
        (new UploadValidate())->goCheck(null,['file'=>$this->request->file()]);
        try {
            $cid = $this->request->post('cid', 0);
            $result = UploadService::video($cid,$this->adminId);
            return $this->success('上传成功', $result);
        } catch (Exception $e) {
            return $this->fail($e->getMessage());
        }
    }

    /**
     * @notes 上传素材
     * @return \think\response\Json
     */
    public function wechatMaterial()
    {
        $file = $this->request->file('file');
        $result = UploadService::wechatMaterial($file);
        if (is_array($result)) {
            return $this->success('', $result);
        }
        return $this->fail($result);

    }

}