<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

/**
 * 首页导航菜单
 * Class GoodsController
 * @package app\adminapi\controller\goods
 */
class SearchLOg extends BaseAdminController
{

    public function list()
    {
        $params = $this->request->get();
        $where = [];

        if(isset($params['type'])){
            $where['search_type']=$params['type'];
        }
        
        $list = \app\common\model\SearchLog::where($where)
        ->order('create_time','desc')
        ->paginate(30);

        return show(config('status.success'),'搜索日志列表',$list);
    }

    public function del($id)
    {
        \app\common\model\SearchLog::destroy($id);

        return show(config('status.success'),'删除成功');
    }

}


