<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\enum\OrderEnum;
use app\common\enum\OrderLogEnum;
use think\model\concern\SoftDelete;

/**
 * 订单日志
 * Class OrderLog
 * @package app\common\model
 */
class OrderLog extends BaseModel
{
    public function record($params)
    {
        $this->insert([
            'type'          => $params['type'],
            'channel'       => $params['channel'],
            'order_id'      => $params['order_id'],
            'operator_id'   => $params['operator_id'] ?? 0,
            'content'       => $params['content'] ?? OrderLogEnum::getRecordDesc($params['channel']),
            'create_time'   => time(),
            'update_time'   => time(),
        ]);
    }

    /**
     * @notes 变动方式获取器
     * @param $value
     * @param $data
     * @return string|string[]
     */
    public function getChannelDescAttr($value,$data)
    {
        return OrderLogEnum::getRecordDesc($data['channel']);
    }

    /**
     * @notes 操作人获取器
     * @param $value
     * @param $data
     * @return mixed|string
     */
    public function getOperatorAttr($value,$data)
    {
        switch ($data['type']) {
            case 1:
                return '系统';
            case 2:
                return Admin::where('id',$data['operator_id'])->value('name');
            case 3:
                return User::where('id',$data['operator_id'])->value('nickname');
            default:
                return '未知';
        }
    }

}