<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\logic;

use app\common\logic\BaseLogic;
use app\common\model\User;
use app\common\service\ConfigService;
use app\common\service\FileService;
use think\facade\Config;

/**
 * 注册逻辑层
 * Class RegisterLogic
 * @package app\api\logic
 */
class RegisterLogic extends BaseLogic
{
    public static function register($params)
    {
        try {
            $defaultAvatar = ConfigService::get('default_image', 'user_avatar');
            $passwordSalt = Config::get('project.unique_identification');

            $password = '';
            if(isset($params['password'])){
                $password = create_password($params['password'], $passwordSalt);
            }

            
            $avatar = \app\common\model\Avatar::orderRaw('rand()')->find();
            if($avatar){
                $defaultAvatar = $avatar->image;
            }

            // 创建用户
            $sn = create_user_sn();
            $data = [
                'register_source' => $params['register_source'],
                'sn' => create_user_sn(),
                'nickname' => '用户' . $sn,
                'avatar' => $defaultAvatar,
                'mobile' => $params['mobile'],
                'user_money' => 0,
                'total_order_amount' => 0,
                'total_order_num' => 0,
                'account' => $params['mobile'],
                'password' => $password,
                'user_growth' => 0,
                'code' => generate_code(),
                'user_earnings' => 0,
                'salt' => $passwordSalt
            ];

            try {
                $ip = $_SERVER['REMOTE_ADDR'];
                $ip_address = '';
                // 初始化，指定QQWry.dat文件路径
                $qqwry = new \app\common\service\QQWry('qqwry.dat');
                // 查询IP地理位置
                $location = $qqwry->getLocation($ip);
                $ip_address = $location['country'];
    
                $data['ip'] = $ip;
                $data['ip_address'] = $ip_address;
                
            } catch (\Exception $e) {
                // echo "发生错误: " . $e->getMessage();
            }

            // 存在邀请码
            if($params['invite_code'] ){
                $inviteUserId = User::where([ 'disable' => 0, 'code' =>$params['invite_code'] ])->value('id');
                if( $inviteUserId ){
                    $data['inviter_id'] = $inviteUserId;
                }
            }

            $user = User::create($data);
            // 注册奖励
            \app\common\logic\UserLogic::registerAward($user->id);

            return $user;
        } catch(\Exception $e) {
            dd($e->getMessage());
            self::setError($e->getMessage());
            return false;
        }
    }




}