<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;

use app\common\logic\ChatLogic;
use app\common\model\ChatMessage;
use app\common\model\ChatRecord;

/**
 * 用户聊天记录列表
 * Class ChatRecordLists
 * @package app\api\lists
 */
class ChatRecordLists extends BaseShopDataLists
{

    /**
     * @notes 设置查询条件
     * @return array[]
     * @date 2022/3/14 14:48
     */
    public function setWhere(): array
    {
        $map1 = [
            ['from_id', '=', $this->userId],
            ['from_type', '=', 'user'],
        ];
        $map2 = [
            ['to_id', '=', $this->userId],
            ['to_type', '=', 'user'],
        ];
        return [$map1, $map2];
    }


    /**
     * @notes 聊天记录列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     * @date 2022/3/14 14:48
     */
    public function lists(): array
    {
        $lists = ChatRecord::whereOr($this->setWhere())
            ->order('id desc')
            ->limit($this->limitOffset, $this->limitLength)
            ->select()->toArray();

        if (!empty($lists)) {
            $lists = ChatLogic::formatChatRecords($lists);
        }

        return $lists;
    }

    /**
     * 私聊聊天记录
     */
    public function chat_private_list($to_id): array
    {
        $where1 = [
            ['from_id','=',$this->userId],
            ['to_id','=',$to_id]
        ];
        $where2 = [
            ['to_id','=',$this->userId],
            ['from_id','=',$to_id]
        ];
        $lists = ChatMessage::whereOr([$where1,$where2])
            ->order('id desc')
            ->limit($this->limitOffset, $this->limitLength)
            // ->buildSql(); 
            ->select()->toArray();

        // echo '生成的sql语句：'.$lists;;die;

        if (!empty($lists)) {
            $lists = ChatLogic::formatChatRecords($lists);
        }

        return $lists;
    }


    /**
     * @notes 记录数量
     * @return int
     * @date 2022/3/14 14:49
     */
    public function count(): int
    {
        return ChatRecord::whereOr($this->setWhere())->count();
    }
}