<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\lists;


use app\common\model\Article;
use app\common\model\ArticleVisit;

class ArticleVisitLists extends BaseShopDataLists 
{

    /**
     * @notes 设置搜索
     */
    public function setSearch()
    {
        $this->searchWhere[] = ['user_id' , '=' , $this->userId];
    }



    /**
     * @notes 列表
     * @return array
     */
    public function lists(): array
    {
        
        $this->setSearch();
        
        $lists = ArticleVisit::with(['article' => function($query){
            $query->with(['user']);
            $query->append(['comment_num' ,'collect_num' ,'zan_num']);
        }])->where($this->searchWhere)
        ->order(['update_time'=>'desc','create_time'=>'desc'])
        ->limit($this->limitOffset, $this->limitLength)
        ->select()
        ->toArray();
        
        $data = [];
        foreach($lists as $k=> $item){
            $data[$k] = $item['article'];
            $data[$k]['visit_id'] = $item['id'];
        }

        return $data;
    }

    /**
     * @notes 文章/帮助总记录数
     * @return int
     */
    public function count(): int
    {
        $this->setSearch();
        
        $count = ArticleVisit::where($this->searchWhere);

        return $count->count();
    }
}