<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;

/**
 * 群管理
 * Summary of Group
 */
class MerchantGoods extends BaseShopController
{

    /**
     * 发布需求
     * @return void
     */
    public function CreateTask()
    {
        $params = $this->request->post();

        $data = [
            'user_id'=>$this->userId,
            'title'=>$params['name'],//任务名
            'desc'=>$params['desc'],//需求描述
            'image'=>$params['image'],//图片
            'price'=>$params['price'],//预算
            'expire_time'=>$params['deadline'],//截至日志,int
            'status'=>1,// 正常
        ];

        $res = \app\common\model\Task::create($data);

        return show(config('status.success'),'添加成成功',$res->id);

    }


    /**
     * 商家商品数据搜索
     * @return void
     */
    public function list()
    {
        $params = $this->request->get();

        $where = [
            ['status','=',1]
        ];

        $list = \app\common\model\Task::with(['user'])
        ->where($where)->paginate(20);

        return show(config('status.success'),'',$list);
    }

    /**
     * 需求分类列表
     * @return void
     */
    public function categoryList()
    {
        $params = $this->request->get();

        $where = [
            ['status','=',1]
        ];

        $list = \app\common\model\TaskCategory::where($where)->paginate(20);

        return show(config('status.success'),'',$list);
    }

    /**
     * 添加报价
     */
    public function addQuotation()
    {
        $params = $this->request->get();

        $task = \app\common\model\Task::find($params['task_id']);
        
        $task_quotation_cout = \app\common\model\TaskQuotation::where([
            'task_id'=>$params['task_id'],
            'status'=>1,
        ])->count();
        
        if($task_quotation_cout > 0){
            return \show(config("status.error"),'此任务已被抢完');
        }

        if($task->status!=1){
            return \show(config('status.error'),'此任务状态不支持报价');
        }

        if($task->exprie < time()){
            return \show(config('status.error'),'已到期');
        }

        $data = [
            'task_id'=>$params['task_id'],
            'user_id'=>$this->userId,
            'price'=>$params['price'],
            'desc'=>$params['desc'],
            'delivery_time'=>$params['delivery_time'],
            'status'=>0,//0=待采用，1采用合同生成，2=不采用
        ];
        
        \app\common\model\TaskQuotation::create($data);

        return \show(config('status.success'),'报价成功');

    }

    /**
     * 任务详情接口
     */
    public function details($id)
    {
        $data = \app\common\model\Task::with(['user','quotation'])->find($id);

        return \show(config('status.success'),'',$data);
    }

    /**
     * 我的发布
     */
    public function mylist()
    {
        $params = $this->request->get();

        $where = [];

        $list = \app\common\model\Task::where('user_id',$this->userId)
        ->where($where)->paginate(20);

        return show(config('status.success'),'',$list);
    }

     /**
     * 删除我的发布
     */
    public function del()
    {
        $params = $this->request->get();

        $where = [];

       $task = \app\common\model\Task::find($params['task_id']);

       if($task->user_id != $this->userId){
            return \show(\config('status.error'),'无权限');
       }

       $task->delete();

       return \show(\config('status.success'),'删除成功');
    }


}