<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate\settings\delivery;


use app\common\model\Freight;
use app\common\validate\BaseValidate;

class FreightValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require|checkId',
        'name' => 'require|checkName',
        'charge_way' => 'require|in:1,2,3',
        'region' => 'require|array|checkRegion',
    ];

    protected $message = [
        'name.require' => '模版名称不能为空',
        'charge.require' => '计费方式不能为空',
        'charge.in' => '计费方式的取值范围在[1,2,3]',
        'region.require' => '配送区域不能为空',
        'region.array' => '配送区域必须为数组',
    ];

    public function sceneAdd()
    {
        return $this->only(['name','charge_way','region']);
    }

    public function sceneEdit()
    {
        return $this->only(['id','name','charge_way','region']);
    }

    public function sceneDetail()
    {
        return $this->only(['id']);
    }

    public function sceneDel()
    {
        return $this->only(['id']);
    }

    /**
     * @notes 检查模版名称是否已存在
     * @param $value
     * @param $rule
     * @param $data
     * @return bool|string
     */
    public function checkName($value,$rule,$data)
    {
        $where[] = ['name', '=', $value];
        //编辑
        if (isset($data['id'])) {
            $where[] = ['id','<>',$data['id']];
        }

        $result = Freight::where($where)->findOrEmpty();
        if (!$result->isEmpty()) {
            return '模版名称已存在';
        }
        return true;
    }

    /**
     * @notes 检查配送区域数据是否完整
     * @param $value
     * @param $rule
     * @param $data
     * @return bool|string
     */
    public function checkRegion($value,$rule,$data)
    {
        foreach ($value as $val) {
            if ($val['region_id'] == '' || $val['first_unit'] == '' || $val['first_money'] == '' || $val['continue_unit'] == '' || $val['continue_money'] == '') {
                return '参数缺失';
            }
            if ($val['first_unit'] < 0 || $val['first_money'] < 0 || $val['continue_unit'] < 0 || $val['continue_money'] < 0) {
                return '配送区域不能存在小于零的数据';
            }
        }

        return true;
    }

    /**
     * @notes 检查ID是否存在
     * @param $value
     * @param $rule
     * @param $data
     * @return bool|string
     */
    public function checkId($value,$rule,$data)
    {
        $result = Freight::where('id',$value)->findOrEmpty();
        if ($result->isEmpty()) {
            return '运费模版不存在';
        }
        return true;
    }
}