<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\validate\goods;


use app\common\model\GoodsComment;
use app\common\validate\BaseValidate;

class GoodsCommentValidate extends BaseValidate
{
    protected $rule = [
        'id' => 'require|array|checkId',
        'status' => 'require|in:0,1,2',
    ];

    public function sceneReply()
    {
        return $this->only(['id']);
    }

    public function sceneDel()
    {
        return $this->only(['id']);
    }

    public function sceneStatus()
    {
        return $this->only(['id','status'])
            ->append('id','checkStatus');
    }

    /**
     * @notes 检查商品评价ID是否存在
     * @param $value
     * @param $rule
     * @param $data
     * @return bool|string
     */
    public function checkId($value,$rule,$data)
    {
        foreach ($value as $val) {
            $result = GoodsComment::findOrEmpty($val);
            if ($result->isEmpty()) {
                return '存在非法ID';
            }
        }

        return true;
    }

    /**
     * @notes 检验评价审核状态
     * @param $value
     * @param $rule
     * @param $data
     * @return bool|string
     */
    public function checkStatus($value,$rule,$data)
    {
        foreach ($value as $val) {
            $result = GoodsComment::findOrEmpty($val);
            if ($result['status'] > 0) {
                return '存在已审核评价，请重新提交';
            }
        }
        return true;
    }
}