<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\settings\delivery;


use app\common\logic\BaseLogic;
use app\common\model\Freight;
use app\common\model\FreightConfig;
use app\common\model\Region;
use think\facade\Db;

class FreightLogic extends BaseLogic
{
    /**
     * @notes 添加运费模版
     * @param $params
     */
    public function add($params)
    {
        // 启动事务
        Db::startTrans();
        try {
            //模版数据入库
            $freight = new Freight;
            $freight->name = $params['name'];
            $freight->charge_way = $params['charge_way'];
            $freight->remark = $params['remark'];
            $freight->save();

            //模版配置数据入库
            $freight_config = new FreightConfig;
            $data = [];
            foreach ($params['region'] as $val) {
                $data[] = [
                    'freight_id' => $freight->id,
                    'region_id' => $val['region_id'],
                    'first_unit' => $val['first_unit'],
                    'first_money' => $val['first_money'],
                    'continue_unit' => $val['continue_unit'],
                    'continue_money' => $val['continue_money'],
                ];
            }
            $freight_config->saveAll($data);

            // 提交事务
            Db::commit();
            return true;
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return $e->getMessage();
        }
    }

    /**
     * @notes 编辑运费模版
     * @param $params
     */
    public function edit($params)
    {
        // 启动事务
        Db::startTrans();
        try {
            //更新运费模版
            $freight = Freight::find($params['id']);
            $freight->name = $params['name'];
            $freight->charge_way = $params['charge_way'];
            $freight->remark = $params['remark'];
            $freight->save();

            //删除旧的运费模版配置
            FreightConfig::destroy(function($query) use($params){
                $query->where('freight_id',$params['id']);
            });

            //添加新的运费模版配置
            $data = [];
            foreach ($params['region'] as $val) {
                $data[] = [
                    'freight_id' => $freight->id,
                    'region_id' => $val['region_id'],
                    'first_unit' => $val['first_unit'],
                    'first_money' => $val['first_money'],
                    'continue_unit' => $val['continue_unit'],
                    'continue_money' => $val['continue_money'],
                ];
            }
            $freight_config = new FreightConfig;
            $freight_config->saveAll($data);

            // 提交事务
            Db::commit();
            return true;
        } catch (\Exception $e) {
            // 回滚事务
            Db::rollback();
            return $e->getMessage();
        }
    }

    /**
     * @notes 查看运费模版详情
     * @param $params
     * @return array
     */
    public function detail($params)
    {
        $freight = Freight::field('id,name,charge_way,remark')->find($params['id']);
        $freight->region->toArray();
        $freight = $freight->toArray();
        foreach ($freight['region'] as &$val) {
            if ($val['region_id'] == 100000) {
                $val['region_name'] = '全国统一运费';
            }else {
                $val['region_name'] = implode('、',Region::where('id','in', $val['region_id'])->column('name'));
            }
        }

        return $freight;
    }

    /**
     * @notes 删除运费模版
     * @param $params
     */
    public function del($params)
    {
        return Freight::destroy($params['id']);
    }
}