<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\finance;

use app\adminapi\logic\distribution\DistributionDataLogic;
use app\common\enum\AfterSaleEnum;
use app\common\enum\PayEnum;
use app\common\enum\YesNoEnum;
use app\common\logic\BaseLogic;
use app\common\model\AfterSale;
use app\common\model\Order;
use app\common\model\User;

/**
 * 财务逻辑层
 * Class FinanceLogic
 * @package app\adminapi\logic\finance
 */
class FinanceLogic extends BaseLogic
{
    /**
     * @notes 数据中心
     * @return array
     */
    public static function dataCenter()
    {
        
        $shopOrder = [];

        if(isActivePluginByPluginName('shop')){
            $shopOrder = [
                'desc'=>'自营商城统计',
                'order_sum' => Order::where('pay_status', PayEnum::ISPAID)->sum('order_amount'),// 订单总支付金额
                'order_num' => \app\common\model\ArticleOrder::where('pay_status', PayEnum::ISPAID)->count('id'),// 订单总支付笔数
                'after_sale_sum' => AfterSale::where('sub_status', AfterSaleEnum::SUB_STATUS_SELLER_REFUND_SUCCESS)->sum('refund_total_amount'),// 售后退款成功总金额
            ];
        }
    
        $articleOrder = [];
        //帖子订单统计
        $articleOrder = [
            'order_amount_sum'=>\app\common\model\ArticleOrder::where('pay_status', PayEnum::ISPAID)->sum('order_amount'),//订单总金额
            'order_num'=>\app\common\model\ArticleOrder::where('pay_status', PayEnum::ISPAID)->count('id'),//订单总数
        ];
        
        
        // 用户总余额(可提现)
        $userMoneySum = User::sum('user_money');
        // 用户总收入(可提现)
        $userEarningsSum = User::sum('user_earnings');
        // 用户总资产
        $userTotalAssets = round($userMoneySum + $userEarningsSum, 2);

        $data = [
            'user_money_sum' => $userMoneySum,
            'user_earnings_sum' => $userEarningsSum+$userMoneySum,
            'user_total_assets' => $userTotalAssets,
            'shop_order'=>$shopOrder,
            'article_order'=>$articleOrder,
        ];
        
        return $data;
    }
}