<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\delivery;


use app\adminapi\controller\BaseAdminController;
use app\adminapi\lists\settings\delivery\ExpressLists;
use app\adminapi\logic\settings\delivery\ExpressLogic;
use app\adminapi\validate\settings\delivery\ExpressValidate;

class Express extends BaseAdminController
{
    /**
     * @notes 添加快递公司
     * @return \think\response\Json
     */
    public function add()
    {
        $params = (new ExpressValidate())->post()->goCheck('add');
        (new ExpressLogic())->add($params);
        return $this->success('添加成功',[],1, 1);
    }

    /**
     * @notes 查看快递公司列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists(new ExpressLists());
    }

    /**
     * @notes 编辑快递公司
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function edit()
    {
        $params = (new ExpressValidate())->post()->goCheck('edit');
        (new ExpressLogic())->edit($params);
        return $this->success('修改成功',[],1,1);
    }

    /**
     * @notes 删除快递公司
     * @return \think\response\Json
     */
    public function del()
    {
        $params = (new ExpressValidate())->post()->goCheck('del');
        (new ExpressLogic())->del($params);
        return $this->success('删除成功',[],1,1);
    }

    /**
     * @notes 查看快递公司详情
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function detail()
    {
        $params = (new ExpressValidate())->goCheck('detail');
        $result = (new ExpressLogic())->detail($params);
        return $this->success('获取成功',$result);
    }
}