<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller\collect\info;

use app\adminapi\controller\BaseAdminController;

/**
 * 西瓜分类信息-分类
 * Class UserController
 * @package app\adminapi\controller\user
 */
class CategoryCollect extends BaseAdminController
{
    // DZ-西瓜/分类行业数据采集
    public function insertDZXG()
    {
        $list = $this->request->post('list');
        $page = $this->request->post('page');

        $saveData=[];

        $err=[];

        foreach($list as $v){
            // dd($v);

            // 将分类保存到圈子里
            $saveData[]=[
                "id"=>$v['id'],
                "name"=>$v['name'],
                "synopsis"=>$v['view_desc'],//简介
                "icon"=>$v['icon'],
                "create_time"=>$v['ts'],
                "subscription_price"=>$v['price'],
                "status"=>1,
            ];

            // dd($v['fields']);
            // 字段数据
            $field=[];
            if(!empty($v['fields'])){
                foreach($v['fields'] as $v2){
                    $field[]=[
                        "circle_id"=>$v['id'],
                        "key"=>$v2['title'],//键名
                        "placehold"=>$v2['placehd'],//表单预设值
                        "type"=>$v2['type'],//配置类型
                        "value"=>$v2['extra'],//配置类型
                        "unit"=>$v2['unitnew'],//单位
                        // "sort"=>$v2['l'],//排序
                    ];
                }
            };

        }

        try{

            $res = \think\facade\Db::name('circle')
            ->extra('IGNORE')
            ->insertAll($saveData);

            if(\isActivePluginByPluginName('field')){
                $res = \think\facade\Db::name('circle_field')
                ->extra('IGNORE')
                ->insertAll($field);
            }

            // $res=\app\common\model\Merchant::insertAll($saveData);

            // dd($res);

            // 记录当前页数 用于下次断点采集
            \app\common\service\ConfigService::set('InfoCategoryCollect','dz_page',$page);

            return \show(1,'导入成功',$err);
        }catch(\Exception $e){
            return \show(0,'导入失败'.$e->getMessage());
        }
        
    }

    // 查询上一次采集到第几页
    public function dzPageRecord()
    {
        $page=\app\common\service\ConfigService::get('InfoCategoryCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

    public function dzPageRecordDel()
    {
        $page=\app\common\service\ConfigService::set('InfoCategoryCollect','dz_page',0);
        return \show(1,['page'=>$page]);
    }

}