<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\service\map;

use app\common\service\ConfigService;
use Requests;

/**
 * 腾讯地图
 * @package 
 */
class TencentService 
{
    /**
     * @notes 地址逆解析
     */
    public static function geocoder($lat, $lon)
    {
       
        // $datas = array(
        //     'location' => $lat . ',' . $lon,
        //     'key'  => ConfigService::get('map', 'tencent_map_key',''),
            
        // );
         $datas = array(
            'location' => $lat . ',' . $lon,
            'key'  => ConfigService::get('map', 'tencent_map_key',''),
            'poi_options' => 'address_format=short;radius=5000;policy=5;orderby=_distance',
            'get_poi' => 1
        );
        $params = "";
        foreach ($datas as $k => $v) {
            $params .= "$k=" . ($v) . "&";
        }
        $params = substr($params, 0, -1);

        $url =  'https://apis.map.qq.com/ws/geocoder/v1/?' . $params;
        // dd($url);
        $result = file_get_contents($url);
        $result = json_decode($result, true);

        if( $result['status'] === 0){
            return $result['result'];
        } else {
            return false;
        }

    }

    public static function search($keyword,$boundary,$page_size,$page_index)
    {

        $datas = array(
            'key'  => ConfigService::get('map', 'tencent_map_key',''),
            'keyword' => $keyword,
            'boundary' => $boundary,
            'page_size' => $page_size,
            'page_index' => $page_index,
        );
        $params = "";
        foreach ($datas as $k => $v) {
            $params .= "$k=" . ($v) . "&";
        }
        $params = substr($params, 0, -1);

        $url =  'https://apis.map.qq.com/ws/place/v1/search?' . $params;
        // dd($url);
        $result = file_get_contents($url);
        $result = json_decode($result, true);

        if( $result['status'] === 0){
            return $result['data'];
        } else {
            // static::$error = $result;
            return false;
        }


    }
}