<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\common\exception;
use app\common\enum\WechatErrorEnum;
use think\Exception;
use Throwable;

/**
 * 微信异常类
 * Class WechatException
 * @package app\common\exception
 */
class WechatException extends Exception
{

    public function __construct($message = "", $code = 0, Throwable $previous = null)
    {
        $wechatMessage = WechatErrorEnum::wechatErrorMessage($code);
        if(empty($wechatMessage)){
            $wechatMessage .= $message.'; 错误码:'.$code;
        }
        $this->message = '微信提示:'.$wechatMessage;
//        $this->code = '错误码：'.$code;
        parent::__construct($this->message, $code, $previous);
    }



}