<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\logic;
use app\common\logic\BaseLogic;
use app\common\model\GoodsCollect;

/**
 * 收藏逻辑层
 * Class CollectLogic
 * @package app\common\logic
 */
class CollectLogic extends BaseLogic
{

    /**
     * @notes 操作收藏商品
     * @param array $params
     * @param int $userId
     * @return bool
     * @author lgp
     */
    public function handleCollectGoods(array $params,int $userId)
    {
        if (!isset($params['is_collect']) || !isset($params['goods_id'])) {
            return '参数缺失';
        }
        //收藏
        if($params['is_collect']){
            $goodsCollect = GoodsCollect::
                        where(['goods_id'=>$params['goods_id'],'user_id'=>$userId])
                        ->findOrEmpty();

            if(!$goodsCollect->isEmpty()){
                return true;
            }
            $goodsCollect->goods_id = $params['goods_id'];
            $goodsCollect->user_id  = $userId;
            $goodsCollect->save();
            return true;
        }
        //取消删除
        GoodsCollect::destroy(['goods_id'=>$params['goods_id'],'user_id'=>$userId]);
        return true;

    }




}
