<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;

use app\common\model\SignEmote;
use app\common\model\SignLog;
use app\common\service\ConfigService;
use app\api\logic\SignLogic;

/**
 * 签到控制器
 * Class SignController
 * @package app\api\controller
 */
class Sign extends BaseShopController
{
    
    public array $notNeedLogin = ['leaderboardToday'];

    /**
     * @notes 查看签到列表
     * @return \think\response\Json
     */
    public function lists()
    {
        $result = SignLogic::lists($this->userId);
        return $this->data($result);
    }

    public function today()
    {
        $log = SignLog::where('user_id', $this->userId)->whereDay('create_time')->find();
        if (!$log) {
            return show(0, '今天未签到');
        }

        return show(1, '今天已签到', $log);
    }

    public function leaderboardToday()
    {
        $result = SignLog::whereDay('create_time')
            ->with('user')
            ->order('create_time')
            ->limit(20)
            ->select()
            ->toArray();

        return show(1, '签到排行榜', $result);
    }

    /**
     * @notes 签到
     * @return \think\response\Json
     */
    public function sign()
    {
        if(!$this->request->isPost()) {
            return $this->fail('请求方式错误');
        }
        $params = $this->request->post();
        $result = SignLogic::sign($this->userId, $params);
        if($result) {
            return $this->success('恭喜您签到成功啦', $result);
        }
        return $this->fail(SignLogic::getError());
    }

    /**
     * @notes 获取签到说明
     * @return \think\response\Json
     */
    public function getRemark()
    {
        $result = ['remark' => ConfigService::get('sign', 'remark')];
        return $this->data($result);
    }

    public function emoteList()
    {
        $data = SignEmote::select();
        return show(1,'表情列表',$data);
    }
}