<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic;

use app\common\enum\DefaultEnum;
use app\common\enum\YesNoEnum;
use app\common\logic\BaseLogic;
use app\common\model\Circle;
use app\common\model\Topic;
use app\common\service\FileService;

class TopicLogic extends BaseLogic
{


    /**
     * @notes 查看详情
     * @param $params
     * @return array
     */
    public static function detail($params)
    {
        $data =Topic::findOrEmpty($params['id'])->toArray();
        return  $data;
    }

    /**
     * @notes 添加
     * @param $params
     */
    public static function add($params)
    {
         $data = [
            'name' => $params['name'],
            'synopsis' => $params['synopsis'],
    
            'sort' => $params['sort'] ?? DefaultEnum::SORT,

            'create_time' => time()
        ];

        Topic::create($data);
    }


    /**
     * @notes 编辑
     * @param $params
     */
    public static function edit($params)
    {
        $data = [
            'name' => $params['name'],
            'synopsis' => $params['synopsis'],
           
            'sort' => $params['sort'] ?? DefaultEnum::SORT,
            
            'create_time' => time()
        ];

        Topic::update($data,['id' => $params['id']]);
    }

    /**
     * @notes 删除
     * @param $params
     */
    public static function delete($params)
    {
        Topic::destroy($params['id']);
    }

    /**
     * @notes 修改是否显示状态
     * @param $params
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function status($params)
    {
        $article = Topic::find($params['id']);
        $article->save(['status' => $params['status']]);
    }


}