<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\controller;

use app\adminapi\lists\ArticleCommentLists;
use app\adminapi\lists\CircleLists;
use app\adminapi\lists\CircleCateLists;
use app\adminapi\lists\TopicLists;
use app\adminapi\validate\ArticleValidate;
use app\adminapi\logic\ArticleLogic;
use app\adminapi\logic\CircleLogic;
use app\adminapi\logic\CircleCateLogic;
use app\adminapi\logic\TopicLogic;
use app\common\enum\NoticeEnum;

class Circle extends BaseAdminController
{
    /**
     * 待审核帖子数量
     */
    public function pendingProcessing()
    {
        $count = \app\common\model\Circle::where('status',0)->count();
        return show(config('status.success'),['count'=>$count]);
    }



    /**
     * @notes 修改审核状态
     * @return \think\response\Json
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function status()
    {
        $params = $this->request->post();
        
        CircleLogic::status($params);

        $circle = \app\common\model\Circle::where('id',$params['id'])->find()->toArray();

        // 拒审系统通知
        if($params['status']==2){
            event('Notice', [
                'scene_id' => NoticeEnum::CIRCLE_EXAMINE_NOTICE,
                'params' => [
                    'type'=>'circle',
                    'user_id'    => $circle['user_id'],  //帖子对应的发布者ID
                    'circle_id' => $params['id'],   //回复的帖子,
                    'content'    => '您的圈子存在违规已拒审',
                ]
            ]);
            \app\common\model\Circle::update(['examine_msg'=>'您的内容存在违规管理员拒审'],['id'=>$params['id']]);
        }elseif($params['status']==1){
            event('Notice', [
                'scene_id' => NoticeEnum::ARTICLE_EXAMINE_NOTICE,
                'params' => [
                    'type'=>'circle',
                    'user_id'    => $circle['user_id'],  //帖子对应的发布者ID
                    'circle_id' => $params['id'],   //回复的帖子,
                    'content'    => '您创建的圈子审核通过',
                ]
            ]);
        }

        return $this->success('修改成功',[],1,1);
    }


    /**
     * 圈子列表
     */ 
    public function lists(){
        return $this->dataLists(new CircleLists());
    }

    public function cate_lists(){
        return $this->dataLists(new CircleCateLists());
    }


    /**
     * @notes 查看详情
     * @return \think\response\Json
     */
    public function detail()
    {
        $params = $this->request->get();
        $result = CircleLogic::detail($params);
        return $this->data($result);
    }



     /**
     * 添加圈子
     * @return \think\response\Json
     */
    public function add()
    {
        $params = $this->request->post();
        $add_res=CircleLogic::add($params);
        return $this->success('添加成功',[],1,1);
    }


    /** 
     * @notes 编辑圈子
     * @return \think\response\Json
     */
    public function edit()
    {
        $params = $this->request->post();
        CircleLogic::edit($params);
        return $this->success('编辑成功',[],1,1);
    }

    /**
     * @notes 删除文章/帮助
     * @return \think\response\Json
     */
    public function delete()
    {
        $params = $this->request->post();
        CircleLogic::delete($params);
        return $this->success('删除成功',[],1,1);
    }


    /**
     * @notes 修改显示
     * @return \think\response\Json
     */

    public function show()
    {
        $params = $this->request->post();
        CircleLogic::show($params);
        return $this->success('修改成功',[],1,1);
    }


    /**
     * 注册审核申请记录
     */
    public function logoffList()
    {
        $where = [];
        $list = \app\common\model\CircleLogoff::with('circle')
        ->where($where)
        ->order('create_time','desc')
        ->paginate(20);

        return show(config('status.success'),'',$list);
    }
    
    /**
     * 圈子注销审核
     */
    public function logoffStatus()
    {
        $params = $this->request->post();

        $data = \app\common\model\CircleLogoff::find($params['id']);

        if($params['status']==1){
            //  同意注销
            \think\facade\Db::startTrans();
            try{
                
                \app\common\model\CircleLogoff::update(['status'=>1],['id'=>$params['id']]);

                \app\common\model\Circle::update(['status'=>3],['id'=>$data->circle_id]);

                \think\facade\Db::commit();

            }catch(\Exception $e){
                \think\facade\Db::rollback();
                return show(config('status.success'),$e->getMessage());
            }

        }elseif($params['status']=2){
            // 修改申请状态 1=已拒绝
            \app\common\model\CircleLogoff::update(['status'=>2],['id'=>$params['id']]);

        }

        return show(config('status.success'),'审核成功');
    }

}