<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller;

use app\common\enum\AccountLogEnum;

/***
 * 账户流水控制器
 * Class AccountLogController
 * @package app\adminapi\controller
 */
class AccountLog extends BaseAdminController
{
    /**
     * @notes 查看账户流水列表
     * @return \think\response\Json
     */
    public function lists()
    {
        return $this->dataLists();
    }

    /**
     * @notes 获取变动类型
     * @return \think\response\Json
     */
    public function getChangeType()
    {
        return $this->data(AccountLogEnum::getChangeTypeDesc('',true));
    }

    /**
     * @notes 获取不可提现余额变动类型
     * @return \think\response\Json
     */
    public function getBnwChangeType()
    {
        return $this->data(AccountLogEnum::getBnwChangeTypeDesc());
    }


    /**
     * @notes 获取可提现余额变动类型
     * @return \think\response\Json
     * @date 2022/3/28 11:14
     */
    public function getBwChangeType()
    {
        return $this->data(AccountLogEnum::getBWChangeTypeDesc());
    }
}