<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;

use app\common\service\FileService;
use think\model\concern\SoftDelete;

/**
 * 用户等级模型
 * Class UserLevel
 * @package app\common\model
 */
class UserLevel extends BaseModel
{
    use SoftDelete;
    //json转数组
    protected $json = ['condition'];
    protected $jsonAssoc = true;

    /**
     * @notes 获取用户等级名称
     * @param $level_id
     * @return mixed|string
     */
    public static function getLevelName($level_id)
    {
        $levels = self::column('name', 'id');
        return $levels[$level_id] ?? '无等级';
    }

    /**
     * @notes 背景图片域名
     * @param $value
     * @return string
     */
    public static function getBackgroundImageAttr($value){
        // return trim($value) ? FileService::getFileUrl($value) : '';
    }

    /**
     * @notes 设置背景图片
     * @param $value
     * @return mixed|string
     */
    public function setBackgroundImageAttr($value)
    {
        return trim($value) ? FileService::setFileUrl($value) : '';
    }
}