<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\common\model;


use app\common\enum\FreightEnum;
use think\model\concern\SoftDelete;

class Freight extends BaseModel
{
    use SoftDelete;
    protected $deleteTime = 'delete_time';

    /**
     * @notes 计费方式名称获取器
     * @param $value
     * @return string
     */
    public function getChargeWayNameAttr($value,$data)
    {
        return FreightEnum::getChargeWay($data['charge_way']);
    }

    /**
     * @notes 一对多关联FreightConfig模型
     * @return \think\model\relation\HasMany
     */
    public function region()
    {
        return $this->hasMany(FreightConfig::class,'freight_id','id')
            ->field('id,region_id,first_unit,first_money,continue_unit,continue_money');
    }
}