<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\validate;
use app\common\{
    model\Goods,
    enum\GoodsEnum,
    validate\BaseValidate
};



/**
 * 分享验证器
 * Class ShareValidate
 * @package  app\api\validate
 */
class ShareValidate extends BaseValidate
{
    protected $rule = [
        'goods_id'      => 'checkGoods',
        'initiate_id'      => 'require',
    ];

    protected $message = [
        'initiate_id.require' => '发起砍价ID缺失'
    ];

    protected $scene = [
        'goods'  =>  ['goods_id'],
        'initiate'  =>  ['initiate_id'],
    ];

    protected function checkGoods($value,$rule,$data){
        $goods = Goods::find($value);
        if(empty($goods)){
            return '商品不存在';
        }
        if(GoodsEnum::STATUS_STORAGE == $goods->status){
            return '商品已下架';
        }
        return true;

    }
}