<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\lists;

use app\common\model\GoodsCollect;

/**
 * 收藏商品列表接口
 * Class GoodsCollectLists
 * @package app\api\lists
 */
class GoodsCollectLists  extends BaseShopDataLists
{


    /**
     * @notes 商品收藏列表
     * @return array
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function lists(): array
    {
        $list = GoodsCollect::with(['goods'])
            ->where(['user_id'=>$this->userId])
            ->limit($this->limitOffset, $this->limitLength)
            ->select()
            ->toArray();

        return $list;

    }


    /**
     * @notes 商品收藏合计
     * @return int
     */
    public function count(): int
    {
        return GoodsCollect::where(['user_id'=>$this->userId])->count();

    }
}