<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\api\controller;
use app\common\enum\NoticeEnum;
use app\api\{
    logic\UserLogic,
    validate\UserValidate,
    validate\SetUserInfoValidate
};



/**
 * 用户控制器
 * Class UserController
 * @package app\api\controller
 */
class Vip extends BaseShopController
{

    /**
     * 会员中心
     */
    public function index()
    {
        // echo '获取当前用户的vip信息和到期时间等';

        $user = \app\common\model\User::with('currentVip')
        ->field('id,vip_level_id,vip_expire_time')
        ->find($this->userId)->toArray();

        // 查询vip等级 和等级下的vip套餐
        $vipList = \app\common\model\VipLevel::with('package')
        ->select()
        ->toArray();

        $data = [
            'user'=>$user,
            'vipList'=>$vipList,
        ];

        return show(config('status.success'),'会员中心',$data);

    }
    
    /**
     * vip套餐
     * Summary of list
     * @return \think\response\Json
     */
    public function list()
    {
        $list = \app\common\model\VipPackage::select()->toArray();
        return show(config('status.success'),'会员套餐列表',$list);
    }

    public function createOrder()
    {
        
        // 判断用户升级vip重新计算升级价
        
        $user_vip_package_id = input('user_vip_package_id');
        $vip_package = \app\common\model\VipPackage::find($user_vip_package_id);

        // 如果当前有更高级的vip，不能再开通低等于vip,需到期后再开通
        $user = \app\common\model\User::find($this->userId);
        // dd($user->vip_expire_time > time());
        if($user->vip_expire_time > time() && $user->vip_level_id != $vip_package->vip_level_id){

            // 判断vip升级，todo...
            
            return show(config('status.error'),'您还有其他身份vip未到期，请会员时间到期后再开通此身份的vip');
        };
        
        
        
        // 创建订单
        $order_data = [
            'sn'=>time().round(10000,99999),
            'user_id'=>$this->userId,
            'vip_level_id'=>$vip_package->vip_level_id,
            'vip_time'=>$vip_package->time,
            'order_amount'=>$vip_package->price,
        ];
        $res = \app\common\model\VipOrder::create($order_data);
        
        if (!$res) {
            return show(config('status.error'),'订单创建失败');
        }

        return show(config('status.success'),'订单创建成功',[
            'order_id'=>$res->id,
        ]);
    }
    
}