<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\api\controller;


use app\api\logic\Order\CartLogic;
use app\api\validate\CartValidate;

/**
 * 购物车
 * Class CartController
 * @package app\api\controller
 */
class Cart extends BaseShopController
{

    /**
     * @notes 购物车列表
     * @return \think\response\Json
     */
    public function lists()
    {   
        if(!\isActivePluginByPluginName('shop')){
            dd("未安装自营商城插件");
        }
        return $this->data(CartLogic::getCartLists($this->userId));
    }


    /**
     * @notes 添加
     * @return \think\response\Json
     */
    public function add()
    {
        $params = (new CartValidate())->post()->gocheck('add', ['user_id' => $this->userId]);
        $result = CartLogic::addCart($params, $this->userId);
        if (true !== $result) {
            return $this->fail($result);
        }
        return $this->success('加入成功');
    }


    /**
     * @notes 删除
     * @return \think\response\Json
     */
    public function del()
    {
        $params = (new CartValidate())->post()->goCheck('del', ['user_id' => $this->userId]);
        CartLogic::del($params['cart_id'], $params['user_id']);
        return $this->success('删除成功');
    }


    /**
     * @notes 变更购物车数量
     * @return \think\response\Json
     */
    public function change()
    {
        $params = (new CartValidate())->post()->goCheck('change', ['user_id' => $this->userId]);
        $result = CartLogic::changeCartNum($params);
        if (true !== $result) {
            return $this->fail($result);
        }
        return $this->success();
    }


    /**
     * @notes 选中状态
     * @return \think\response\Json
     */
    public function selected()
    {
        $params = (new CartValidate())->post()->goCheck('selected', ['user_id' => $this->userId]);
        CartLogic::selected($params);
        return $this->success();
    }


    /**
     * @notes 购物车数量
     * @return \think\response\Json
     */
    public function num()
    {
        return $this->data(CartLogic::getCartNum($this->userId));
    }


}