<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */

namespace app\adminapi\logic\settings\app;

use app\common\logic\BaseLogic;
use app\common\model\DevUpgrade;
use app\common\service\ConfigService;

/**
 * App设置逻辑层
 * Class AppSettingLogic
 * @package app\adminapi\logic\settings\app
 */
class AppSettingLogic extends BaseLogic
{
    /**
     * @notes 获取App设置
     * @return array
     */
    public static function getConfig()
    {
        $config = [
            'ios_download_url'      => ConfigService::get('app', 'ios_download_url', ''),
            'android_download_url'  => ConfigService::get('app', 'android_download_url', ''),
            'download_title'        => ConfigService::get('app', 'download_title', ''),
            'app_id'                => ConfigService::get('open_platform', 'app_id', ''),
            'app_secret'            => ConfigService::get('open_platform', 'app_secret', ''),
            'pop_agreement'         => ConfigService::get('app','pop_agreement',1),
        ];

        return $config;
    }

    /**
     * @notes App设置
     */
    public static function setConfig($params)
    {
        ConfigService::set('app', 'ios_download_url', $params['ios_download_url'] ?? '');
        ConfigService::set('app', 'android_download_url', $params['android_download_url'] ?? '');
        ConfigService::set('app', 'download_title', $params['download_title'] ?? '');
        ConfigService::set('open_platform', 'app_id', $params['app_id'] ?? '');
        ConfigService::set('open_platform', 'app_secret', $params['app_secret'] ?? '');
        ConfigService::set('app', 'pop_agreement', $params['pop_agreement'] ?? 1);
    }

    /**
     * @notes 添加APP更新
     */
    public static function upgradeAdd($params)
    {
        $data = [
            'title'     => $params['title'],
            'version'   => implode('.',$params['version']),
            'terminal'  => $params['terminal'],
            'force_update'  => $params['force_update'],
            'create_time' => time()
        ];

        return DevUpgrade::create($data);
    }


    /**
     * 删除 APP 更新版本
     */
    public static function upgradeDel($params){

        $data = DevUpgrade::destroy($params['id']);
        return  $data;
    }

    /**
     * @notes 修改强制更新状态
     * @param $params
     */
    public static function upgradeStatus($params)
    {
        $upgrade = DevUpgrade::find($params['id']);
        $upgrade->save(['force_update' => $params['force_update']]); 
    }

}