<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\goods;


use app\common\enum\DefaultEnum;
use app\common\enum\YesNoEnum;
use app\common\model\GoodsBrand;

class GoodsBrandLogic
{
    /**
     * @notes 添加商品品牌
     * @param $params
     * @return bool
     */
    public function add($params)
    {
        $goods_brand = new GoodsBrand;
        $goods_brand->name = $params['name'];
        $goods_brand->image = $params['image'] ?? '';
        $goods_brand->sort = (isset($params['sort']) && !empty($params['sort'])) ? $params['sort'] : DefaultEnum::SORT;
        $goods_brand->is_show = $params['is_show'] ?? YesNoEnum::YES;
        return $goods_brand->save();
    }

    /**
     * @notes 删除商品品牌
     * @param $params
     * @return bool
     */
    public function del($params)
    {
        return GoodsBrand::destroy($params['id']);
    }

    /**
     * @notes 编辑商品品牌
     * @param $params
     * @return bool
     */
    public function edit($params)
    {
        $goods_brand = GoodsBrand::find($params['id']);
        $goods_brand->name = $params['name'];
        $goods_brand->image = $params['image'];
        $goods_brand->is_show = $params['is_show'];
        $goods_brand->sort = $params['sort'];
        return $goods_brand->save();
    }

    /**
     * @notes 修改商品品牌显示状态
     * @param $params
     * @return bool
     */
    public function status($params)
    {
        $goods_brand = GoodsBrand::find($params['id']);
        $goods_brand->is_show = $params['is_show'];
        return $goods_brand->save();
    }

    /**
     * @notes 查看商品品牌详情
     * @param $params
     * @return array
     */
    public function detail($params)
    {
        return GoodsBrand::find($params['id'])->toArray();
    }
}