<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\logic\ad;

use app\common\model\AdPosition;
use app\common\enum\AdEnum;
use app\common\logic\BaseLogic;
use app\common\model\Ad;
use app\common\service\FileService;
use think\facade\Db;

/**
 * 广告位逻辑层
 * Class AdLogic
 * @package app\adminapi\logic\AdLogic
 */
class PositionLogic extends BaseLogic
{
    
    /**
     * @notes 查看详情
     * @param $params
     * @return string[]
     */
    public static function detail($params)
    {
        $data = AdPosition::findOrEmpty($params['id'])->toArray();
        return  $data;
    }

    /**
     * @notes 添加
     * @param $params
     */
    public static function add($params)
    {
        $data = [
            'name'     => $params['name'],
            'attr'      => 1,
            'width'     => $params['width']  ?? 0,
            'height'    => $params['height'] ?? 0,
            'status'    => $params['status'],
            'client'    => AdEnum::mobile,
            'create_time' => time()
        ];

        return AdPosition::create($data);
    }

    /**
     * @notes 编辑
     * @param $params
     */
    public static function edit($params)
    {
        $data = [
            'name'     => $params['name'],
            'attr'      => 1,
            'width'     => $params['width']  ?? 0,
            'height'    => $params['height'] ?? 0,
            'status'    => $params['status'],
            'client'    => AdEnum::mobile,
            'update_time' => time()
        ];

        return  AdPosition::update($data,['id' => $params['id']]);
    }

    /**
     * @notes 删除
     * @param $params
     */
    public static function delete($params)
    {
        return AdPosition::destroy($params['id']);
    }

    /**
     * @notes 修改是否显示状态
     * @param $params
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public static function status($params)
    {
        $article = AdPosition::find($params['id']);
        $article->save(['status' => $params['status']]);
    }

    
}