<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */



namespace app\adminapi\controller\wechat;

use app\adminapi\controller\BaseAdminController;
use app\adminapi\logic\wechat\MiniProgramSettingLogic;
use app\adminapi\validate\wechat\MiniProgramSettingValidate;

use app\common\service\ConfigService;

/**
 * 微信公众号设置控制器
 * Class MiniProgramSettingController
 * @package app\adminapi\controller\wechat
 */
class OfficialSetting extends BaseAdminController
{

    /**
     * @notes 获取微信小程序设置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        
        $config = [
            
            // 公众号
            'app_id'                =>   ConfigService::get('official', 'app_id', ''),
            'app_secret'            =>   ConfigService::get('official', 'app_secret', ''),

            // 开放平台
            'open_app_id'                =>   ConfigService::get('official', 'open_app_id', ''),
            'open_app_secret'            =>   ConfigService::get('official', 'open_app_secret', ''),

        ];

        return show(config('status.success'),'',$config);
    }

    /**
     * @notes 微信小程序设置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        // 公众号p
        ConfigService::set('official','app_id', $params['app_id'] ?? '');
        ConfigService::set('official','app_secret',$params['app_secret'] ?? '');

        // 开放平台
        ConfigService::set('official','open_app_id', $params['open_app_id'] ?? '');
        ConfigService::set('official','open_app_secret',$params['open_app_secret'] ?? '');

        return show(config('status.success'),'设置成功');
    }
}
