<?php
/**
 *  ╔═══════════════════════════════════════════════════╗
 *  ║                                                   ║
 *  ║     ██╗  ██╗   █████╗    ██████╗                  ║
 *  ║     ██║  ██║  ██╔══██╗  ██╔═══██╗                 ║
 *  ║     ███████║  ███████║  ██║   ██║                 ║
 *  ║     ██╔══██║  ██╔══██║  ██║   ██║                 ║
 *  ║     ██║  ██║  ██║  ██║  ╚██████╔╝   SNS           ║
 *  ║                                                   ║    
 *  ║                                                   ║    
 *  ║     © 2023 HaoSNS™ All Rights Reserved            ║
 *  ║     官方网站: https://www.haosns.com                *
 *  ║     本代码由赣州乐易网络科技有限公司®提供             *
 *  ║                                                    *
 *  ║   未经授权禁止复制、传播或用于其他商业目的            *
 *  ║                                                   ║
 *  ╚═══════════════════════════════════════════════════╝
 */


namespace app\adminapi\controller\settings\delivery;


use app\adminapi\controller\BaseAdminController;
use app\adminapi\lists\settings\delivery\DeliveryWayLists;
use app\adminapi\logic\settings\delivery\DeliveryWayLogic;
use app\adminapi\validate\settings\delivery\DeliveryWayValidate;

class DeliveryWay extends BaseAdminController
{
    /**
     * @notes 查看配送方式配置
     * @return \think\response\Json
     */
    public function getConfig()
    {
        $result = (new DeliveryWayLogic())->getConfig();
        return $this->success('获取成功',$result);
    }

    /**
     * @notes 设置配送方式配置
     * @return \think\response\Json
     */
    public function setConfig()
    {
        $params = (new DeliveryWayValidate())->post()->goCheck();
        (new DeliveryWayLogic())->setConfig($params);
        return $this->success('设置成功',[],1,1);
    }
}