<?php

namespace app\adminapi\controller;

class FakeUserAvatar extends BaseAdminController
{
    public function list()
    {
        $list = \app\common\model\FakeUserAvatar::select()
            ->toArray();

        return show(1, '', $list);
    }

    public function create()
    {
        $params = $this->request->post();
        $res = \app\common\model\FakeUserAvatar::create($params);
        if (!$res) {
            return show(0, '添加失败');
        };
        return show(1, '添加成功');
    }

    public function del($id)
    {
        \app\common\model\FakeUserAvatar::destroy($id);

        return show(config('status.success'), '删除成功');
    }

    public function detail($id)
    {
        $res = \app\common\model\FakeUserAvatar::where('id', $id)->find();
        if (!$res) {
            return show(0, '查询失败');
        };
        return show(1, '查询成功', $res);
    }


    public function update()
    {
        $params = $this->request->post();
        $res = \app\common\model\FakeUserAvatar::where('id', $params['id'])->update($params);
        if (!$res) {
            return show(0, '修改失败');
        };
        return show(1, '修改成功');
    }
}